package com.ElyStudio.leGaou.activities;

import androidx.core.content.ContextCompat;

import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.ElyStudio.leGaou.R;
import com.ElyStudio.leGaou.databinding.ActivityPrivacyPolicyScreenBinding;
import com.ElyStudio.leGaou.models.AboutApp;
import com.ElyStudio.leGaou.utilities.ApiController;
import com.ElyStudio.leGaou.utilities.AppCompat;
import com.ElyStudio.leGaou.utilities.CheckInternetConnection;
import com.ElyStudio.leGaou.utilities.QuizzeSnackBar;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class PrivacyPolicyScreen extends AppCompat {

    ActivityPrivacyPolicyScreenBinding binding;
    public static final String TAG = "PRIVACY_POLICY_SCREEN";
    BottomSheetDialog noInternetBottomSheet;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityPrivacyPolicyScreenBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());
    }

    @Override
    protected void onStart() {
        super.onStart();
        getAboutApp();
    }

    private void getAboutApp(){

        if(CheckInternetConnection.isInternetConnected(PrivacyPolicyScreen.this))
        {
            Call<AboutApp> getAboutAppCall = ApiController.getInstance().getApi().getAboutApp();

            getAboutAppCall.enqueue(new Callback<AboutApp>() {
                @Override
                public void onResponse(Call<AboutApp> call, Response<AboutApp> response) {
                    if(response.body().getStatusCode() == 0)
                    {
                        binding.privacyPolicy.setText(response.body().getPrivacyPolicy());
                    }
                }

                @Override
                public void onFailure(Call<AboutApp> call, Throwable t) {
                    Log.d(TAG,"getAboutAppCall Failure = "+t.getLocalizedMessage());
                }
            });
        }
        else
        {
            showNoInternetBottomSheet();
        }



    }

    public void showNoInternetBottomSheet(){

        noInternetBottomSheet = new BottomSheetDialog(PrivacyPolicyScreen.this);
        View view = LayoutInflater.from(PrivacyPolicyScreen.this).inflate(R.layout.error_occurred_bottom_sheet,findViewById(R.id.errorOccurredBottomSheetLayout),false);
        noInternetBottomSheet.setContentView(view);

        Button contactSupportBtn = noInternetBottomSheet.findViewById(R.id.bottomSheetSecondaryButton);
        Button tryAgainBtn = noInternetBottomSheet.findViewById(R.id.bottomSheetPrimaryButton);
        ImageView bottomSheetIllustration = noInternetBottomSheet.findViewById(R.id.bottomSheetIllustraton);
        TextView bottomSheetTitle = noInternetBottomSheet.findViewById(R.id.bottomSheetTitle);
        noInternetBottomSheet.setCancelable(false);
        TextView bottomSheetSubText = noInternetBottomSheet.findViewById(R.id.bottomSheetSubText);
        contactSupportBtn.setVisibility(View.GONE);

        tryAgainBtn.setText(getResources().getString(R.string.try_again));

        tryAgainBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(CheckInternetConnection.isInternetConnected(PrivacyPolicyScreen.this))
                {
                    noInternetBottomSheet.cancel();
                    getAboutApp();
                }
                else
                {
                    QuizzeSnackBar.showSnackBar(PrivacyPolicyScreen.this,view,getResources().getString(R.string.no_internet),getResources().getColor(R.color.error));
                }
            }
        });

        bottomSheetTitle.setText(getResources().getString(R.string.no_internet));
        bottomSheetSubText.setText(getResources().getString(R.string.no_internet_sub_text));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable(PrivacyPolicyScreen.this,R.drawable.no_conection_illustration));

        if(!PrivacyPolicyScreen.this.isFinishing())
        {
            noInternetBottomSheet.show();
        }

    }
}